var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-2F8D0342-6833-46AA-B3A7-BF067F5966D6\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Understanding the tutorial components</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-2F8D0342-6833-46AA-B3A7-BF067F5966D6\"></a><div class=\"head\">\n            <h1>Understanding the tutorial components</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183666\"></a>This tutorial shows you how to set up a simulated slag foundry that is composed of\n            the following components:\n         </p>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183667\"></a> \n            <h2><a name=\"GUID-11AF30A9-990B-47A3-9583-6E26D25B6442\"></a>nParticle objects\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183668\"></a>You create a total of three nParticle systems to simulate the slag foundry scene.\n               All three systems are controlled by the same Nucleus solver node. The first nParticle\n               system (<em class=\"mild\">nParticle_slag</em>) added to the scene simulates the slag that flows down the chute. You convert this\n               <span class=\"MenuCascade\" id=\"GUID-10506C65-9F40-4348-9CD7-773DFCD5CAD4\">Ball</span> style nParticle object to an nParticle output mesh then shade and texture it with\n               a fractal texture. The assigned texture gives the output mesh the appearance of molten\n               metal when rendered. You create, adjust, and shade the <em class=\"mild\">nParticle_slag</em> and output mesh objects, in Lesson 1. See <span class=\"char_link\"><a href=\"GUID-4B56F022-E983-4359-B5C9-083FDE5BFFBF.htm\">Lesson 1 Creating the molten slag</a></span>.\n            </p> \n            <p><a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-76ED\"></a>The remaining two nParticle systems simulate the metal sparks that fly off the slag\n               flow. To generate the sparks, you create a two-stage effect that is initiated by a\n               particle collision event. The nParticle_slag object that you create in Lesson 1 acts\n               as the source particle system for the collision event. \n            </p> \n            <p><a name=\"WS73099CC142F4875516078EA312754F1D2D4-7C08\"></a>After the resulting target particle system (<em class=\"mild\">nParticle_sparks_emitter</em>) is generated by the event, it becomes a surface emitter for the nParticle sparks\n               (<em class=\"mild\">nParticle_sparks</em>). To create the look and streaking behavior of the sparks, you use the <span class=\"MenuCascade\" id=\"GUID-77DAE549-2897-4213-8A98-97E2E67C5A03\">Tube (s/w)</span> particle render type. The two-stage sparks effect is created in Lesson 3. See <span class=\"char_link\"><a href=\"GUID-82778CB7-B4CF-4BFF-BA56-732C876B9F58.htm\">Lesson 3 Creating flying sparks</a></span>.\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183669\"></a> \n            <h2><a name=\"GUID-8A85A990-16B9-406D-9B3F-6B95860FBEF0\"></a>nParticle output mesh\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366A\"></a>An nParticle output mesh is generated from the nParticle_slag object. This mesh is\n               the visible slag that flows down the chute into the tub. It is also used as a surface\n               emitter for a 3D fluid. The fluid effect creates the smoke that rises above the molten\n               slag as it slides down the slag chute into the tub. The output mesh is textured with\n               a 2D fractal texture to give it the orange glow of molten metal when the scene is\n               rendered. The mesh is created and adjusted in Lesson 1. See <span class=\"char_link\"><a href=\"GUID-4B56F022-E983-4359-B5C9-083FDE5BFFBF.htm\">Lesson 1 Creating the molten slag</a></span>.\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366B\"></a> \n            <h2><a name=\"GUID-284A6A3D-C229-467F-8839-B2642E55C74E\"></a>3D fluid effect\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366C\"></a>The 3D fluid is emitted into the scene from the surface of the nParticle output mesh.\n               It simulates the smoke and steam that rises from the molten slag as flows down the\n               chute. The fluid container uses Fluid Auto Resize so that it can follow the slag while\n               maintaining a manageable container size. The fluid is created in Lesson 2. See <span class=\"char_link\"><a href=\"GUID-95CDCC54-C71E-4EDA-98C7-CE73EB9343CE.htm\">Lesson 2 Creating the slag smoke</a></span>.\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366D\"></a> \n            <h2><a name=\"GUID-B0CDCA07-D769-486E-B229-A2A7E4E808EC\"></a>External gravity field \n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366E\"></a>You apply an external <span class=\"MenuCascade\" id=\"GUID-8B1F082B-53BD-48D0-BE6E-F2F9B9518EA1\">Gravity </span>field to the nParticle_Sparks object to create the arcing behavior of the sparks as\n               they fly off the slag. Also, to create realistic spark behavior, you will simulate\n               with <span class=\"MenuCascade\" id=\"GUID-6CF1E230-D020-4A06-84F0-A3BB75004B9C\">Ignore Solver Gravity</span> turned on. The gravity field is added to the scene in Lesson 3. See <span class=\"char_link\"><a href=\"GUID-82778CB7-B4CF-4BFF-BA56-732C876B9F58.htm\">Lesson 3 Creating flying sparks</a></span>.\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC18366F\"></a> \n            <h2><a name=\"GUID-F967D0E0-9A63-4A6D-8081-5BBF206F4499\"></a>Non-dynamic objects\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183670\"></a>Lights, a camera, and render settings are added to the scene so that you can render\n               out a frame or part of a sequence at various stages of the tutorial. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183671\"></a> \n            <h2><a name=\"GUID-6C257DF7-51C0-4A6B-8967-40D0BAD211D6\"></a>Tutorial workflow\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-30857B3612671CDEC183672\"></a>The scene files for each lesson let you complete specific aspects of the tutorial.\n               You can start the tutorial using the scene file for Lesson 1 and continue to add the\n               tutorial components until you complete all four lessons. Otherwise, each lesson can\n               be completed separately using the following scene files:\n            </p> <a name=\"WS73099CC142F4875516078EA312754F1D2D4-7C07\"></a><ul>\n               <li>For Lesson 1: Creating the molten slag, use SlagPourFoundry_1.mb</li>\n               <li>For Lesson 2: Creating the slag smoke, use SlagPourFoundry_2.mb</li>\n               <li>For Lesson 3: Creating flying sparks, use SlagPourFoundry_3.mb</li>\n               <li>For Beyond the tutorial, use SlagPourFoundry_4.mb</li>\n            </ul> \n            <p><a name=\"WS73099CC142F4875516078EA312754F1D2D4-7808\"></a>To watch a video of the rendered simulation, open <em class=\"mild\">SlagPourFoundryFinal.mp4v</em>, included with the tutorial lesson files.\n            </p> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";